; Copyright 2002-2009 by Autodesk, Inc. All Rights Reserved.
;
; Permission to use, copy, modify, and distribute this software
; for any purpose and without fee is hereby granted, provided that
; the above copyright notice appears in all copies and that both
; the copyright notice and the limited warranty and restricted rights
; notice below appear in all supporting documentation.
;
; AUTODESK, INC. PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
; AUTODESK, INC. SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
; MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
; DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
; UNINTERRUPTED OR ERROR FREE.
;
; Use, duplication, or disclosure by the U.S. Government is subject to
; restrictions set forth in FAR 52.227-19 (Commercial Computer
; Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
; (Rights in Technical Data and Computer Software), as applicable.
;
; 12-Feb-09 NEHolt now passing in the second, parallel list for BOM report data that indicates
;    what each element in the display list is... 1=main BOM element, 2=Subassy or Multi-cat
;    element. This list must be kept in synch with the main display list if entries in
;    the main display list are reordered.
; 01-Oct-03 Mauro Sist globalized
; ** 29-Sep-02 NEHolt adjusted for calling from either VIA-WD Add-on or Stand Alone. Stand 
;    Alone requires that only one overall routine is defined, must be called "_wd_post_main". 
;    Any subroutines defined in this file MUST be defined internal to this main routine.
; ** 02-Jul-01 NEHolt N8 Solutions, Inc / VIA Development. Created 
;    as sample post-process util
; ---------  T A G _ P B O M . L S P  -----------------------------
;
; This routine is called from AutoCAD Electrical's "User post" button on the
; schem PNLBOM (By Tag format) dialog display. Report data is passed to this
; routine in AutoLISP variable called "wd_rdata". This utility can
; then operate on this report data, reformat it into a new list of
; report data "rtrn" and then pass it back to AutoCAD Electrical's report dialog 
; through a call to (c:wd_rtrn_2wd rtrn) shown at the end of this file.
;
(defun _wd_post_main ( / rtrn dclnam dcl_id user_1 user_2 user_3 cancel xx wlay1
                         lay_map_lst data wd_make_dcl wd_nth_subst
                         ix lst n newlst slen val x
                         combined_data combined_data_dsplstwhat)
                         ; Do not define "wd_rdata" as local variable!
  ; -- internal subroutines

  ; --
  (defun wd_nth_subst ( n val lst / newlst ix slen x )
    ; Substitute the nth member of a list "lst" with new value "val"
    ; If "n" is past end of existing list then blank positions "nil" padded
    (if (not lst)
      (setq slen 0)
      (setq slen (length lst))
    )
    (cond
      ((minusp n)  ) ; rtrn orig list if pos is neg number
      ((zerop n) (setq lst (cons val (cdr lst)))) ; n=0, replace 1st item
      ((= n slen) (setq lst (append lst (list val)))) ; new last item
      ((< n slen) ; Insert item somewhere else in list
        (setq ix 0)
        (setq newlst '())
        (foreach x lst
          (if (/= ix n)
            (setq newlst (cons x newlst)) ; reuse existing
            (setq newlst (cons val newlst)) ; substitute new
          )
          (setq ix (1+ ix))
        )
        (setq lst (reverse newlst))
        (setq newlst nil)
      )
      ((> n slen) ; lengthen list, add "nil" pads as req'd
        (setq lst (reverse lst))
        (while (< slen n)
          (setq lst (cons nil lst))  ; add pads
          (setq slen (1+ slen))
        )
        (setq lst (reverse (cons val lst))) ; tack new item on end
    ) )
   lst
  )                         
  ; -- main routine --
  (setq rtrn nil)
  (setq temp nil)
  ; AutoCAD Electrical passes the BOM report displayed data as a list of lists of lists in variable
  ; called wd_rdata. The first element of this list is the list of lists of report data.
  ; The 2nd element is a parallel list of digits indicating "what" each sublist is: 
  ; 1=main BOM entry, 2=subassy or multi-catalog entry.
  (if (AND wd_rdata (car wd_rdata) (listp (car wd_rdata)))
    (progn
      (setq combined_data (car wd_rdata)) ; raw BOM data list of lists
      (setq combined_data_dsplstwhat (cadr wd_rdata)) ; parallel list of flags (1=main, 2=subassy or multi-cat)
  ) )

  ; Look for dcl file of same name, open if found.
  (setq cancel nil)
  (if (setq dclnam (c:ace_find_file "tag_pbom.dcl" 16)) ; 16=display error dialog if file not found
    (progn
      (setq dcl_id (load_dialog dclnam))                
      (if (new_dialog "main_select" dcl_id)
        (progn
          (setq user_1 "0") ; Default state of toggles
          (setq user_2 "0")
          (setq user_3 "0")      
          (set_tile "user1" user_1) ; set toggles per defaults above
          (set_tile "user2" user_2)
          (set_tile "user3" user_3)
          (action_tile "user1" "(setq user_1 $value)")
          (action_tile "user2" "(setq user_2 $value)")
          (action_tile "user3" "(setq user_3 $value)")
          (action_tile "cancel" "(setq cancel 1)")
          (start_dialog)
          (unload_dialog dcl_id)
  ) ) ) )
  
  ; Each sublist within combined_data list of lists:
  ; nth 0=ITEM
  ; nth 1=QTY
  ; nth 2=SUBQTY/COUNT
  ; nth 3=CAT
  ; nth 4=MFG
  ; nth 5=ASSYCODE
  ; nth 6=
  ; nth 7=catalog DESC
  ; nth 8=catalog QUERY2 field
  ; nth 9=catalog QUERY3 field
  ; nth 10=catalog MISC1 field
  ; nth 11=catalog MISC2 field
  ; nth 12=catalog USER1 field
  ; nth 13=catalog USER2 field
  ; nth 14=catalog USER3 field
  ; nth 15=TABNAM
  ; nth 16=TAG-ID
  ; nth 17=INST
  ; nth 18=LOC
  ; nth 19=MOUNT
  ; nth 20=GROUP
  ; nth 21=(sublist of TAG-ID's) - should be just one
  ; nth 22=
  ; nth 23=(sublist of lists of (handle DWGIX)) - should be just one
  ; nth 24=(sublist of lists of (DESC1 DESC2 DESC3 INST LOC MOUNT GROUP UnitMeasure)
  
  (if (AND combined_data (not cancel))
    (progn ; user didn't cancel out of dialog, okay to continue  
      (if (= user_1 "1")
        (progn
          (princ
            (strcat "\n " (c:wd_msg "WLAY031" (list "1" "tag_pbom.lsp") "Nothing defined for user%1 option (see %2)"))
      ) ) )
      (if (= user_2 "1")
        (progn
          (princ
            (strcat "\n " (c:wd_msg "WLAY031" (list "2" "tag_pbom.lsp") "Nothing defined for user%1 option (see %2)"))
      ) ) )
      (if (= user_3 "1")
        (progn
          (princ
            (strcat "\n " (c:wd_msg "WLAY031" (list "3" "tag_pbom.lsp") "Nothing defined for user%1 option (see %2)"))
      ) ) )
    )  
  )  
  (setq rtrn (list combined_data combined_data_dsplstwhat))
  (c:wd_rtrn_2wd rtrn) ; return post-processed list back to AutoCAD Electrical's report dialog
                       ; = nil or combined_data list of lists
)

; -- the following AUTO-STARTS when this file is "loaded" from within AutoCAD Electrical (i.e.
;    user hits the "User post" button on a report display dialog)
(_wd_post_main) ; run the above program
(princ)
